package de.DroolsGUI;
import java.io.File;

import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;

import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.io.ResourceFactory;
import org.drools.runtime.StatefulKnowledgeSession;



public class DroolsGUIModel {

	private static KnowledgeBuilder builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
	private static KnowledgeBase knowledgeBase;
	private static StatefulKnowledgeSession session;
	
	public DroolsGUIModel(){
		
	}

	
	/**
	 * Checks for Compile Errors
	 * @return
	 */
	public boolean errorCheck(){
		boolean errors = false;
		if (builder.hasErrors()) {
			errors = true;
			throw new RuntimeException(builder.getErrors().toString());
		}
		 return errors;
	}
	
	/**
	 * Create the knowledge base
	 */
	public static void createKnowledgeBase() {

		knowledgeBase = KnowledgeBaseFactory.newKnowledgeBase();
		knowledgeBase.addKnowledgePackages(builder.getKnowledgePackages());
		session = knowledgeBase.newStatefulKnowledgeSession();
		
	}
	
	/**
	 * Fires all activated Rules
	 */
	public void fireRules(){
		if(session != null){
			session.fireAllRules();
		}else System.out.println("Sie mssen erst ihre .drl File(s) angeben, dann auf Compiler Fehler prfen und erst dann lassen sich die Regeln abfeuern!");
	}
	
	/**
	 * 
	 * @param filePath
	 */
	public void addKnowledgeToBuilder(String filePath){
		//Pfad fixen
		filePath.replace("\\", "\\\\");
		// Add drl file into builder
		File rules = new File(filePath);
		builder.add(ResourceFactory.newFileResource(rules), ResourceType.DRL);
		
	}
	
	public void removeAllInput(){
		builder = KnowledgeBuilderFactory.newKnowledgeBuilder();
		knowledgeBase = null;
		session.dispose();
		session = null;
		
	}

}
	
	